﻿using UnityEngine;
using System.Collections;

public class LVL1_Begin : StoryEvent
{
    protected Brick[] m_Bricks;

    public override void StartStory()
    {
        base.StartStory();
        m_Bricks = GameObject.Find("Level/Level creator").GetComponentsInChildren<Brick>();
        StartCoroutine("C_Begin");
    }
    
    private IEnumerator C_Begin()
    {
        GameManager.Instance.PlayerCanMove = false;
        yield return new WaitForSeconds(2f);
        foreach (Brick cube in m_Bricks)
        {
            cube.Illumin();
        }

        yield return new WaitForSeconds(4f);
        GameManager.Instance.PlayerCanMove = true;
        m_Finished = true;
    }
}